<!DOCTYPE html>

<?php if($language): ?>
    <?php if($language->rtl): ?>
        <html lang="en" dir="rtl">
    <?php else: ?>
        <html lang="en">
    <?php endif; ?>
<?php else: ?>
    <html lang="en">
<?php endif; ?>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="shortcut icon" href="<?php echo e(url('assets/images/logo/' . (system_setting('favicon_icon') ?? null))); ?>" type="image/x-icon">
    <title><?php echo $__env->yieldContent('title'); ?> || <?php echo e(config('app.name')); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <?php echo $__env->make('layouts.include', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/sidebar-responsive.css')); ?>">
    <?php echo $__env->yieldContent('css'); ?>
    
    <!-- Global Language Data for TinyMCE RTL Support -->
    <script>
        window.globalLanguageData = {
            current: {
                rtl: <?php echo e($language && $language->rtl ? 'true' : 'false'); ?>,
                code: "<?php echo e($language ? $language->code : 'en'); ?>",
                name: "<?php echo e($language ? $language->name : 'English'); ?>"
            },
            all: {
                <?php if(isset($allLanguages) && $allLanguages->count() > 0): ?>
                    <?php $__currentLoopData = $allLanguages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        "<?php echo e($lang->id); ?>": {
                            "rtl": <?php echo e($lang->rtl ? 'true' : 'false'); ?>,
                            "code": "<?php echo e($lang->code); ?>",
                            "name": "<?php echo e($lang->name); ?>"
                        }<?php echo e($loop->last ? '' : ','); ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            }
        };
    </script>
</head>

<body>
    <div id="app">
        <?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <!-- Mobile sidebar overlay -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>

        <div id="main" class='layout-navbar'>
            <?php echo $__env->make('layouts.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div id="main-content">
                <div class="page-heading">

                    <?php echo $__env->yieldContent('page-title'); ?>
                </div>
                <?php echo $__env->yieldContent('content'); ?>

            </div>

        </div>
        <div class="wrapper mt-5">
            <div class="content">
                <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <!-- Your page content here -->
            </div>
        </div>
        
    </div>

    <?php echo $__env->make('layouts.footer_script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('js'); ?>
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\Projects\ebroker-admin\resources\views/layouts/main.blade.php ENDPATH**/ ?>