

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Payment Settings')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>

            </div>
            <div class="col-12 col-md-6 order-md-2 order-first">

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <?php echo Form::open(['route' => 'store-payment-gateway-settings', 'data-parsley-validate', 'class' => 'create-form', 'data-success-function'=> "formSuccessFunction",'enctype' => 'multipart/form-data']); ?>


            
            <div class="card">
                <div class="card-body">
                    <a id="search-anchor-paypal" name="paypal"></a>
                    
                    <div class="divider pt-3 mt-3">
                        <h6 class="divider-text"><?php echo e(__('Paypal Setting')); ?></h6>
                    </div>
                    <div class="form-group row">

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Paypal Client ID')); ?></label>
                            <input name="paypal_client_id" type="text" class="form-control" placeholder="<?php echo e(__('Paypal Client ID')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['paypal_client_id']) && $paymentSettings['paypal_client_id'] != '' ? $paymentSettings['paypal_client_id'] : '' ) : '****************************' ) : ( isset($paymentSettings['paypal_client_id']) && $paymentSettings['paypal_client_id'] != '' ? $paymentSettings['paypal_client_id'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Paypal Client Secret')); ?></label>
                            <input name="paypal_client_secret" type="text" class="form-control" placeholder="<?php echo e(__('Paypal Client Secret')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['paypal_client_secret']) && $paymentSettings['paypal_client_secret'] != '' ? $paymentSettings['paypal_client_secret'] : '' ) : '****************************' ) : ( isset($paymentSettings['paypal_client_secret']) && $paymentSettings['paypal_client_secret'] != '' ? $paymentSettings['paypal_client_secret'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Paypal Webhook URL')); ?></label>
                            <input name="paypal_webhook_url" type="text" class="form-control" placeholder="<?php echo e(__('Paypal Webhook URL')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['paypal_webhook_url']) && $paymentSettings['paypal_webhook_url'] != '' ? $paymentSettings['paypal_webhook_url'] : '' ) : '****************************' ) : ( isset($paymentSettings['paypal_webhook_url']) && $paymentSettings['paypal_webhook_url'] != '' ? $paymentSettings['paypal_webhook_url'] : url('/webhook/paypal') ))); ?>" readonly>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Paypal Webhook ID')); ?></label>
                            <input name="paypal_webhook_id" type="text" class="form-control" placeholder="<?php echo e(__('Paypal Webhook ID')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['paypal_webhook_id']) && $paymentSettings['paypal_webhook_id'] != '' ? $paymentSettings['paypal_webhook_id'] : '' ) : '****************************' ) : ( isset($paymentSettings['paypal_webhook_id']) && $paymentSettings['paypal_webhook_id'] != '' ? $paymentSettings['paypal_webhook_id'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label"><?php echo e(__('Paypal Currency Symbol')); ?></label>
                            <select name="paypal_currency" id="paypal_currency" class="choosen-select form-select form-control-sm">
                                <?php $__currentLoopData = $paypalCurrencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value=<?php echo e($key); ?> <?php echo e(isset($paymentSettings['paypal_currency']) && $paymentSettings['paypal_currency'] == $key ? 'selected' : ''); ?>> <?php echo e($key); ?> - <?php echo e($value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>


                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label" id='lbl_paypal'><?php echo e(__('Enable')); ?></label>
                            <div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="paypal_gateway" id="paypal_gateway" value="<?php echo e(isset($paymentSettings['paypal_gateway']) && $paymentSettings['paypal_gateway'] != '' ? $paymentSettings['paypal_gateway'] : 0); ?>">
                                    <input class="form-check-input" type="checkbox" role="switch" class="switch-input" name='op' <?php echo e(isset($paymentSettings['paypal_gateway']) && $paymentSettings['paypal_gateway'] == '1' ? 'checked' : ''); ?> id="switch_paypal_gateway">
                                    <label class="form-check-label" for="switch_paypal_gateway"></label>
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label"><?php echo e(__('Sandbox Mode')); ?></label>
                            <div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="sandbox_mode" id="sandbox_mode" value="<?php echo e(isset($paymentSettings['sandbox_mode']) && $paymentSettings['sandbox_mode'] != '' ? $paymentSettings['sandbox_mode'] : 0); ?>">
                                    <input class="form-check-input" type="checkbox" role="switch" <?php echo e(isset($paymentSettings['sandbox_mode']) && $paymentSettings['sandbox_mode'] == '1' ? 'checked' : ''); ?> id="switch_sandbox_mode">
                                    <label class="form-check-label" for="switch_sandbox_mode"></label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="card">
                <div class="card-body">

                    <a id="search-anchor-razorpay" name="razorpay"></a>
                    
                    <div class="divider pt-3 mt-3">
                        <h6 class="divider-text"><?php echo e(__('Razorpay Setting')); ?></h6>
                    </div>

                    <div class="form-group row">

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Razorpay key')); ?></label>
                            <input name="razor_key" type="text" class="form-control" placeholder="<?php echo e(__('Razorpay Key')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['razor_key']) && $paymentSettings['razor_key'] != '' ? $paymentSettings['razor_key'] : '' ) : '****************************' ) : ( isset($paymentSettings['razor_key']) && $paymentSettings['razor_key'] != '' ? $paymentSettings['razor_key'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Razorpay Webhook URL')); ?></label>
                            <input name="razorpay_webhook_url" type="text" class="form-control" placeholder="<?php echo e(__('Razorpay Webhook URL')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['razorpay_webhook_url']) && $paymentSettings['razorpay_webhook_url'] != '' ? $paymentSettings['razorpay_webhook_url'] : '' ) : '****************************' ) : ( isset($paymentSettings['razorpay_webhook_url']) && $paymentSettings['razorpay_webhook_url'] != '' ? $paymentSettings['razorpay_webhook_url'] : url('/webhook/razorpay') ))); ?>" readonly>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Razorpay Secret')); ?></label>
                            <input name="razor_secret" type="text" class="form-control" placeholder="<?php echo e(__('Razorpay Secret')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['razor_secret']) && $paymentSettings['razor_secret'] != '' ? $paymentSettings['razor_secret'] : '' ) : '****************************' ) : ( isset($paymentSettings['razor_secret']) && $paymentSettings['razor_secret'] != '' ? $paymentSettings['razor_secret'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label" id='lbl_razorpay'><?php echo e(__('Enable')); ?></label>
                            <div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="razorpay_gateway" id="razorpay_gateway" value="<?php echo e(isset($paymentSettings['razorpay_gateway']) && $paymentSettings['razorpay_gateway'] != '' ? $paymentSettings['razorpay_gateway'] : 0); ?>">
                                    <input class="form-check-input" type="checkbox" role="switch" class="switch-input" name='op' <?php echo e(isset($paymentSettings['razorpay_gateway']) && $paymentSettings['razorpay_gateway'] == '1' ? 'checked' : ''); ?> id="switch_razorpay_gateway">
                                    <label class="form-check-label" for="switch_razorpay_gateway"></label>
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Razorpay Webhook Secret')); ?></label>
                            <input name="razor_webhook_secret" type="text" class="form-control" placeholder="<?php echo e(__('Razorpay Webhook Secret')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['razor_webhook_secret']) && $paymentSettings['razor_webhook_secret'] != '' ? $paymentSettings['razor_webhook_secret'] : '' ) : '****************************' ) : ( isset($paymentSettings['razor_webhook_secret']) && $paymentSettings['razor_webhook_secret'] != '' ? $paymentSettings['razor_webhook_secret'] : '' ))); ?>">
                        </div>

                    </div>
                </div>
            </div>

            
            <div class="card">
                <div class="card-body">

                    <a id="search-anchor-paystack" name="paystack"></a>
                    
                    <div class="divider pt-3 mt-3">
                        <h6 class="divider-text"><?php echo e(__('Paystack Setting')); ?></h6>
                    </div>

                    <div class="form-group row">

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Paystack Secret key')); ?></label>
                            <input name="paystack_secret_key" type="text" class="form-control" placeholder="<?php echo e(__('Paystack Secret Key')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['paystack_secret_key']) && $paymentSettings['paystack_secret_key'] != '' ? $paymentSettings['paystack_secret_key'] : '' ) : '****************************' ) : ( isset($paymentSettings['paystack_secret_key']) && $paymentSettings['paystack_secret_key'] != '' ? $paymentSettings['paystack_secret_key'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Paystack Webhook URL')); ?></label>
                            <input name="paystack_webhook_url" type="text" class="form-control" placeholder="<?php echo e(__('Paystack Webhook URL')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['paystack_webhook_url']) && $paymentSettings['paystack_webhook_url'] != '' ? $paymentSettings['paystack_webhook_url'] : '' ) : '****************************' ) : ( isset($paymentSettings['paystack_webhook_url']) && $paymentSettings['paystack_webhook_url'] != '' ? $paymentSettings['paystack_webhook_url'] : url('/webhook/paystack') ))); ?>" readonly>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Paystack Currency Symbol')); ?></label>
                            <select name="paystack_currency" id="paystack_currency" class="choosen-select form-select form-control-sm">
                                <option value="GHS" <?php echo e(isset($paymentSettings['paystack_currency']) && $paymentSettings['paystack_currency'] == 'GHS' ? 'selected' : ''); ?>> GHS - Ghanaian Cedi</option>
                                <option value="KES" <?php echo e(isset($paymentSettings['paystack_currency']) && $paymentSettings['paystack_currency'] == 'KES' ? 'selected' : ''); ?>> KES - Kenyan Shilling</option>
                                <option value="NGN" <?php echo e(isset($paymentSettings['paystack_currency']) && $paymentSettings['paystack_currency'] == 'NGN' ? 'selected' : ''); ?>> NGN - Nigerian Naira</option>
                                <option value="USD" <?php echo e(isset($paymentSettings['paystack_currency']) && $paymentSettings['paystack_currency'] == 'USD' ? 'selected' : ''); ?>> USD - United States Dollar</option>
                                <option value="XOF" <?php echo e(isset($paymentSettings['paystack_currency']) && $paymentSettings['paystack_currency'] == 'XOF' ? 'selected' : ''); ?>> XOF - West African CFA Franc</option>
                                <option value="ZAR" <?php echo e(isset($paymentSettings['paystack_currency']) && $paymentSettings['paystack_currency'] == 'ZAR' ? 'selected' : ''); ?>> ZAR - South African Rand</option>
                            </select>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label" id='lbl_paystack'><?php echo e(__('Enable')); ?></label>
                            <div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="paystack_gateway" id="paystack_gateway" value="<?php echo e(isset($paymentSettings['paystack_gateway']) && $paymentSettings['paystack_gateway'] != '' ? $paymentSettings['paystack_gateway'] : 0); ?>">
                                    <input class="form-check-input" type="checkbox" role="switch" class="switch-input" name='op' <?php echo e(isset($paymentSettings['paystack_gateway']) && $paymentSettings['paystack_gateway'] == '1' ? 'checked' : ''); ?> id="switch_paystack_gateway">
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Paystack Public key')); ?></label>
                            <input name="paystack_public_key" type="text" class="form-control" placeholder="<?php echo e(__('Paystack Public Key')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['paystack_public_key']) && $paymentSettings['paystack_public_key'] != '' ? $paymentSettings['paystack_public_key'] : '' ) : '****************************' ) : ( isset($paymentSettings['paystack_public_key']) && $paymentSettings['paystack_public_key'] != '' ? $paymentSettings['paystack_public_key'] : '' ))); ?>">
                        </div>

                    </div>
                </div>
            </div>

            
            <div class="card">
                <div class="card-body">
                    <a id="search-anchor-stripe" name="stripe"></a>
                    
                    <div class="divider pt-3 mt-3">
                        <h6 class="divider-text"><?php echo e(__('Stripe Setting')); ?></h6>
                    </div>

                    <div class="form-group row">
                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Stripe publishable key')); ?></label>
                            <input name="stripe_publishable_key" type="text" class="form-control" placeholder="<?php echo e(__('Stripe publishable key')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['stripe_publishable_key']) && $paymentSettings['stripe_publishable_key'] != '' ? $paymentSettings['stripe_publishable_key'] : '' ) : '****************************' ) : ( isset($paymentSettings['stripe_publishable_key']) && $paymentSettings['stripe_publishable_key'] != '' ? $paymentSettings['stripe_publishable_key'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Stripe Webhook URL')); ?></label>
                            <input name="stripe_webhook_url" type="text" class="form-control" placeholder="<?php echo e(__('Stripe Webhook URL')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['stripe_webhook_url']) && $paymentSettings['stripe_webhook_url'] != '' ? $paymentSettings['stripe_webhook_url'] : '' ) : '****************************' ) : ( isset($paymentSettings['stripe_webhook_url']) && $paymentSettings['stripe_webhook_url'] != '' ? $paymentSettings['stripe_webhook_url'] : url('/webhook/stripe') ))); ?>" readonly>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label"><?php echo e(__('Stripe Currency Symbol')); ?></label>
                            <select name="stripe_currency" id="stripe_currency" class="choosen-select form-select form-control-sm">
                                <?php $__currentLoopData = $stripe_currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value=<?php echo e($value); ?>

                                <?php echo e(isset($paymentSettings['stripe_currency']) && $paymentSettings['stripe_currency'] == $value ? 'selected' : ''); ?>>
                                <?php echo e($value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label" id='lbl_stripe'><?php echo e(__('Enable')); ?></label>
                            <div>
                                <div class="form-check form-switch ">
                                    <input type="hidden" name="stripe_gateway" id="stripe_gateway" value="<?php echo e(isset($paymentSettings['stripe_gateway']) && $paymentSettings['stripe_gateway'] != '' ? $paymentSettings['stripe_gateway'] : 0); ?>">
                                    <input class="form-check-input" type="checkbox" role="switch" class="switch-input" name='op' <?php echo e(isset($paymentSettings['stripe_gateway']) && $paymentSettings['stripe_gateway'] == '1' ? 'checked' : ''); ?> id="switch_stripe_gateway">
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label-mandatory"><?php echo e(__('Stripe Secret key')); ?></label>
                            <input name="stripe_secret_key" type="text" class="form-control" placeholder="<?php echo e(__('Stripe Secret key')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['stripe_secret_key']) && $paymentSettings['stripe_secret_key'] != '' ? $paymentSettings['stripe_secret_key'] : '' ) : '****************************' ) : ( isset($paymentSettings['stripe_secret_key']) && $paymentSettings['stripe_secret_key'] != '' ? $paymentSettings['stripe_secret_key'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label-mandatory"><?php echo e(__('Stripe Webhook Secret key')); ?></label>
                            <input name="stripe_webhook_secret_key" type="text" class="form-control" placeholder="<?php echo e(__('Stripe Webhook Secret key')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['stripe_webhook_secret_key']) && $paymentSettings['stripe_webhook_secret_key'] != '' ? $paymentSettings['stripe_webhook_secret_key'] : '' ) : '****************************' ) : ( isset($paymentSettings['stripe_webhook_secret_key']) && $paymentSettings['stripe_webhook_secret_key'] != '' ? $paymentSettings['stripe_webhook_secret_key'] : '' ))); ?>">
                        </div>

                    </div>
                </div>
            </div>

            
            <div class="card">
                <div class="card-body">
                    <a id="search-anchor-flutterwave" name="flutterwave"></a>
                    
                    <div class="divider pt-3 mt-3">
                        <h6 class="divider-text"><?php echo e(__('Flutterwave Setting')); ?></h6>
                    </div>
                    <div class="form-group row">

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Public Key')); ?></label>
                            <input name="flutterwave_public_key" type="text" class="form-control" placeholder="<?php echo e(__('Public Key')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['flutterwave_public_key']) && $paymentSettings['flutterwave_public_key'] != '' ? $paymentSettings['flutterwave_public_key'] : '' ) : '****************************' ) : ( isset($paymentSettings['flutterwave_public_key']) && $paymentSettings['flutterwave_public_key'] != '' ? $paymentSettings['flutterwave_public_key'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Secret Key')); ?></label>
                            <input name="flutterwave_secret_key" type="text" class="form-control" placeholder="<?php echo e(__('Secret Key')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['flutterwave_secret_key']) && $paymentSettings['flutterwave_secret_key'] != '' ? $paymentSettings['flutterwave_secret_key'] : '' ) : '****************************' ) : ( isset($paymentSettings['flutterwave_secret_key']) && $paymentSettings['flutterwave_secret_key'] != '' ? $paymentSettings['flutterwave_secret_key'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Encryption Key')); ?></label>
                            <input name="flutterwave_encryption_key" type="text" class="form-control" placeholder="<?php echo e(__('Encryption Key')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['flutterwave_encryption_key']) && $paymentSettings['flutterwave_encryption_key'] != '' ? $paymentSettings['flutterwave_encryption_key'] : '' ) : '****************************' ) : ( isset($paymentSettings['flutterwave_encryption_key']) && $paymentSettings['flutterwave_encryption_key'] != '' ? $paymentSettings['flutterwave_encryption_key'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Flutterwave Webhook URL')); ?></label>
                                <input name="flutterwave_webhook_url" type="text" class="form-control" placeholder="<?php echo e(__('Flutterwave Webhook URL')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['flutterwave_webhook_url']) && $paymentSettings['flutterwave_webhook_url'] != '' ? $paymentSettings['flutterwave_webhook_url'] : '' ) : '****************************' ) : ( isset($paymentSettings['flutterwave_webhook_url']) && $paymentSettings['flutterwave_webhook_url'] != '' ? $paymentSettings['flutterwave_webhook_url'] : url('/webhook/flutterwave') ))); ?>" readonly>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Flutterwave Currency Symbol')); ?></label>
                            <select name="flutterwave_currency" id="flutterwave_currency" class="choosen-select form-select form-control-sm">
                                <option value="GBP" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'GBP' ? 'selected' : ''); ?>> British Pound Sterling (GBP)</option>
                                <option value="CAD" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'CAD' ? 'selected' : ''); ?>> Canadian Dollar (CAD)</option>
                                <option value="XAF" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'XAF' ? 'selected' : ''); ?>> Central African CFA Franc (XAF)</option>
                                <option value="CLP" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'CLP' ? 'selected' : ''); ?>> Chilean Peso (CLP)</option>
                                <option value="COP" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'COP' ? 'selected' : ''); ?>> Colombian Peso (COP)</option>
                                <option value="EGP" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'EGP' ? 'selected' : ''); ?>> Egyptian Pound (EGP)</option>
                                <option value="EUR" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'EUR' ? 'selected' : ''); ?>> SEPA (EUR)</option>
                                <option value="GHS" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'GHS' ? 'selected' : ''); ?>> Ghanaian Cedi (GHS)</option>
                                <option value="GNF" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'GNF' ? 'selected' : ''); ?>> Guinean Franc (GNF)</option>
                                <option value="KES" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'KES' ? 'selected' : ''); ?>> Kenyan Shilling (KES)</option>
                                <option value="MWK" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'MWK' ? 'selected' : ''); ?>> Malawian Kwacha (MWK)</option>
                                <option value="MAD" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'MAD' ? 'selected' : ''); ?>> Moroccan Dirham (MAD)</option>
                                <option value="NGN" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'NGN' ? 'selected' : ''); ?>> Nigerian Naira (NGN)</option>
                                <option value="RWF" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'RWF' ? 'selected' : ''); ?>> Rwandan Franc (RWF)</option>
                                <option value="SLL" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'SLL' ? 'selected' : ''); ?>> Sierra Leonean Leone (SLL)</option>
                                <option value="STD" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'STD' ? 'selected' : ''); ?>> São Tomé and Príncipe dobra (STD)</option>
                                <option value="ZAR" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'ZAR' ? 'selected' : ''); ?>> South African Rand (ZAR)</option>
                                <option value="TZS" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'TZS' ? 'selected' : ''); ?>> Tanzanian Shilling (TZS)</option>
                                <option value="UGX" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'UGX' ? 'selected' : ''); ?>> Ugandan Shilling (UGX)</option>
                                <option value="USD" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'USD' ? 'selected' : ''); ?>> United States Dollar (USD)</option>
                                <option value="XOF" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'XOF' ? 'selected' : ''); ?>> West African CFA Franc BCEAO (XOF)</option>
                                <option value="ZMW" <?php echo e(isset($paymentSettings['flutterwave_currency']) && $paymentSettings['flutterwave_currency'] == 'ZMW' ? 'selected' : ''); ?>> Zambian Kwacha (ZMW)</option>
                            </select>
                        </div>


                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label" id='lbl_flutterwave'><?php echo e(__('Enable')); ?></label>
                            <div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="flutterwave_status" id="flutterwave_status" value="<?php echo e(isset($paymentSettings['flutterwave_status']) && $paymentSettings['flutterwave_status'] != '' ? $paymentSettings['flutterwave_status'] : 0); ?>">
                                    <input class="form-check-input" type="checkbox" role="switch" class="switch-input" name='op' <?php echo e(isset($paymentSettings['flutterwave_status']) && $paymentSettings['flutterwave_status'] == '1' ? 'checked' : ''); ?> id="switch_flutterwave_status">
                                    <label class="form-check-label" for="switch_flutterwave_status"></label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="card">
                <div class="card-body">
                    <a id="search-anchor-cashfree" name="cashfree"></a>
                    
                    <div class="divider pt-3 mt-3">
                        <h6 class="divider-text"><?php echo e(__('Cashfree Setting')); ?></h6>
                    </div>
                    <div class="form-group row">

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Cashfree App ID')); ?></label>
                            <input name="cashfree_app_id" type="text" class="form-control" placeholder="<?php echo e(__('Cashfree App ID')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['cashfree_app_id']) && $paymentSettings['cashfree_app_id'] != '' ? $paymentSettings['cashfree_app_id'] : '' ) : '****************************' ) : ( isset($paymentSettings['cashfree_app_id']) && $paymentSettings['cashfree_app_id'] != '' ? $paymentSettings['cashfree_app_id'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Cashfree Secret Key')); ?></label>
                            <input name="cashfree_secret_key" type="text" class="form-control" placeholder="<?php echo e(__('Cashfree Secret Key')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['cashfree_secret_key']) && $paymentSettings['cashfree_secret_key'] != '' ? $paymentSettings['cashfree_secret_key'] : '' ) : '****************************' ) : ( isset($paymentSettings['cashfree_secret_key']) && $paymentSettings['cashfree_secret_key'] != '' ? $paymentSettings['cashfree_secret_key'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Cashfree Currency Symbol')); ?></label>
                            <select name="cashfree_currency" id="cashfree_currency" class="choosen-select form-select form-control-sm">
                                <?php $__currentLoopData = $cashfreeCurrencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value=<?php echo e($key); ?> <?php echo e(isset($paymentSettings['cashfree_currency']) && $paymentSettings['cashfree_currency'] == $key ? 'selected' : ''); ?>> <?php echo e($key.' - '.$value['name'].' ('.$value['symbol'].')'); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label" id='lbl_cashfree'><?php echo e(__('Enable')); ?></label>
                            <div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="cashfree_gateway" id="cashfree_gateway" value="<?php echo e(isset($paymentSettings['cashfree_gateway']) && $paymentSettings['cashfree_gateway'] != '' ? $paymentSettings['cashfree_gateway'] : 0); ?>">
                                    <input class="form-check-input" type="checkbox" role="switch" class="switch-input" name='op' <?php echo e(isset($paymentSettings['cashfree_gateway']) && $paymentSettings['cashfree_gateway'] == '1' ? 'checked' : ''); ?> id="switch_cashfree_gateway">
                                    <label class="form-check-label" for="switch_cashfree_gateway"></label>
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label"><?php echo e(__('Sandbox Mode')); ?></label>
                            <div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="cashfree_sandbox_mode" id="cashfree_sandbox_mode" value="<?php echo e(isset($paymentSettings['cashfree_sandbox_mode']) && $paymentSettings['cashfree_sandbox_mode'] != '' ? $paymentSettings['cashfree_sandbox_mode'] : 0); ?>">
                                    <input class="form-check-input" type="checkbox" role="switch" <?php echo e(isset($paymentSettings['cashfree_sandbox_mode']) && $paymentSettings['cashfree_sandbox_mode'] == '1' ? 'checked' : ''); ?> id="switch_cashfree_sandbox_mode">
                                    <label class="form-check-label" for="switch_cashfree_sandbox_mode"></label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="card">
                <div class="card-body">
                    <a id="search-anchor-phonepe" name="phonepe"></a>
                    
                    <div class="divider pt-3 mt-3">
                        <h6 class="divider-text"><?php echo e(__('PhonePe Setting')); ?></h6>
                    </div>
                    <div class="form-group row">

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('PhonePe Client ID')); ?></label>
                            <input name="phonepe_client_id" type="text" class="form-control" placeholder="<?php echo e(__('PhonePe Client ID')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['phonepe_client_id']) && $paymentSettings['phonepe_client_id'] != '' ? $paymentSettings['phonepe_client_id'] : '' ) : '****************************' ) : ( isset($paymentSettings['phonepe_client_id']) && $paymentSettings['phonepe_client_id'] != '' ? $paymentSettings['phonepe_client_id'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('PhonePe Client Secret')); ?></label>
                            <input name="phonepe_client_secret" type="text" class="form-control" placeholder="<?php echo e(__('PhonePe Client Secret')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['phonepe_client_secret']) && $paymentSettings['phonepe_client_secret'] != '' ? $paymentSettings['phonepe_client_secret'] : '' ) : '****************************' ) : ( isset($paymentSettings['phonepe_client_secret']) && $paymentSettings['phonepe_client_secret'] != '' ? $paymentSettings['phonepe_client_secret'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Client Version')); ?></label>
                            <input name="phonepe_client_version" type="text" class="form-control" placeholder="<?php echo e(__('Client Version')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['phonepe_client_version']) && $paymentSettings['phonepe_client_version'] != '' ? $paymentSettings['phonepe_client_version'] : '' ) : '****************************' ) : ( isset($paymentSettings['phonepe_client_version']) && $paymentSettings['phonepe_client_version'] != '' ? $paymentSettings['phonepe_client_version'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Merchant ID')); ?></label>
                            <input name="phonepe_merchant_id" type="text" class="form-control" placeholder="<?php echo e(__('Merchant ID')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['phonepe_merchant_id']) && $paymentSettings['phonepe_merchant_id'] != '' ? $paymentSettings['phonepe_merchant_id'] : '' ) : '****************************' ) : ( isset($paymentSettings['phonepe_merchant_id']) && $paymentSettings['phonepe_merchant_id'] != '' ? $paymentSettings['phonepe_merchant_id'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('PhonePe Webhook URL')); ?></label>
                            <input name="phonepe_webhook_url" type="text" class="form-control" placeholder="<?php echo e(__('PhonePe Webhook URL')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['phonepe_webhook_url']) && $paymentSettings['phonepe_webhook_url'] != '' ? $paymentSettings['phonepe_webhook_url'] : '' ) : '****************************' ) : ( isset($paymentSettings['phonepe_webhook_url']) && $paymentSettings['phonepe_webhook_url'] != '' ? $paymentSettings['phonepe_webhook_url'] : url('/webhook/phonepe') ))); ?>" readonly>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('PhonePe Webhook Username')); ?></label>
                            <input name="phonepe_webhook_username" type="text" class="form-control" placeholder="<?php echo e(__('PhonePe Webhook Username')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['phonepe_webhook_username']) && $paymentSettings['phonepe_webhook_username'] != '' ? $paymentSettings['phonepe_webhook_username'] : '' ) : '****************************' ) : ( isset($paymentSettings['phonepe_webhook_username']) && $paymentSettings['phonepe_webhook_username'] != '' ? $paymentSettings['phonepe_webhook_username'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('PhonePe Webhook Password')); ?></label>
                            <input name="phonepe_webhook_password" type="text" class="form-control" placeholder="<?php echo e(__('PhonePe Webhook Password')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['phonepe_webhook_password']) && $paymentSettings['phonepe_webhook_password'] != '' ? $paymentSettings['phonepe_webhook_password'] : '' ) : '****************************' ) : ( isset($paymentSettings['phonepe_webhook_password']) && $paymentSettings['phonepe_webhook_password'] != '' ? $paymentSettings['phonepe_webhook_password'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label" id='lbl_phonepe'><?php echo e(__('Enable')); ?></label>
                            <div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="phonepe_gateway" id="phonepe_gateway" value="<?php echo e(isset($paymentSettings['phonepe_gateway']) && $paymentSettings['phonepe_gateway'] != '' ? $paymentSettings['phonepe_gateway'] : 0); ?>">
                                    <input class="form-check-input" type="checkbox" role="switch" class="switch-input" name='op' <?php echo e(isset($paymentSettings['phonepe_gateway']) && $paymentSettings['phonepe_gateway'] == '1' ? 'checked' : ''); ?> id="switch_phonepe_gateway">
                                    <label class="form-check-label" for="switch_phonepe_gateway"></label>
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label"><?php echo e(__('Sandbox Mode')); ?></label>
                            <div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="phonepe_sandbox_mode" id="phonepe_sandbox_mode" value="<?php echo e(isset($paymentSettings['phonepe_sandbox_mode']) && $paymentSettings['phonepe_sandbox_mode'] != '' ? $paymentSettings['phonepe_sandbox_mode'] : 0); ?>">
                                    <input class="form-check-input" type="checkbox" role="switch" <?php echo e(isset($paymentSettings['phonepe_sandbox_mode']) && $paymentSettings['phonepe_sandbox_mode'] == '1' ? 'checked' : ''); ?> id="switch_phonepe_sandbox_mode">
                                    <label class="form-check-label" for="switch_phonepe_sandbox_mode"></label>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            
            <div class="card">
                <div class="card-body">
                    <a id="search-anchor-midtrans" name="midtrans"></a>
                    
                    <div class="divider pt-3 mt-3">
                        <h6 class="divider-text"><?php echo e(__('Midtrans Setting')); ?></h6>
                    </div>
                    <div class="form-group row">

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Midtrans Server Key')); ?></label>
                            <input name="midtrans_server_key" type="text" class="form-control" placeholder="<?php echo e(__('Midtrans Server Key')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['midtrans_server_key']) && $paymentSettings['midtrans_server_key'] != '' ? $paymentSettings['midtrans_server_key'] : '' ) : '****************************' ) : ( isset($paymentSettings['midtrans_server_key']) && $paymentSettings['midtrans_server_key'] != '' ? $paymentSettings['midtrans_server_key'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Midtrans Client Key')); ?></label>
                            <input name="midtrans_client_key" type="text" class="form-control" placeholder="<?php echo e(__('Midtrans Client Key')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['midtrans_client_key']) && $paymentSettings['midtrans_client_key'] != '' ? $paymentSettings['midtrans_client_key'] : '' ) : '****************************' ) : ( isset($paymentSettings['midtrans_client_key']) && $paymentSettings['midtrans_client_key'] != '' ? $paymentSettings['midtrans_client_key'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Midtrans Merchant ID')); ?></label>
                            <input name="midtrans_merchant_id" type="text" class="form-control" placeholder="<?php echo e(__('Midtrans Merchant ID')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['midtrans_merchant_id']) && $paymentSettings['midtrans_merchant_id'] != '' ? $paymentSettings['midtrans_merchant_id'] : '' ) : '****************************' ) : ( isset($paymentSettings['midtrans_merchant_id']) && $paymentSettings['midtrans_merchant_id'] != '' ? $paymentSettings['midtrans_merchant_id'] : '' ))); ?>">
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-label"><?php echo e(__('Midtrans Webhook URL')); ?></label>
                            <input name="midtrans_webhook_url" type="text" class="form-control" placeholder="<?php echo e(__('Midtrans Webhook URL')); ?>" value="<?php echo e((env('DEMO_MODE') ? ( env('DEMO_MODE') == true && Auth::user()->email == 'superadmin@gmail.com' ? ( isset($paymentSettings['midtrans_webhook_url']) && $paymentSettings['midtrans_webhook_url'] != '' ? $paymentSettings['midtrans_webhook_url'] : '' ) : '****************************' ) : ( isset($paymentSettings['midtrans_webhook_url']) && $paymentSettings['midtrans_webhook_url'] != '' ? $paymentSettings['midtrans_webhook_url'] : url('/webhook/midtrans') ))); ?>" readonly>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label" id='lbl_midtrans'><?php echo e(__('Enable')); ?></label>
                            <div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="midtrans_gateway" id="midtrans_gateway" value="<?php echo e(isset($paymentSettings['midtrans_gateway']) && $paymentSettings['midtrans_gateway'] != '' ? $paymentSettings['midtrans_gateway'] : 0); ?>">
                                    <input class="form-check-input" type="checkbox" role="switch" class="switch-input" name='op' <?php echo e(isset($paymentSettings['midtrans_gateway']) && $paymentSettings['midtrans_gateway'] == '1' ? 'checked' : ''); ?> id="switch_midtrans_gateway">
                                    <label class="form-check-label" for="switch_midtrans_gateway"></label>
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label"><?php echo e(__('Sandbox Mode')); ?></label>
                            <div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="midtrans_sandbox_mode" id="midtrans_sandbox_mode" value="<?php echo e(isset($paymentSettings['midtrans_sandbox_mode']) && $paymentSettings['midtrans_sandbox_mode'] != '' ? $paymentSettings['midtrans_sandbox_mode'] : 0); ?>">
                                    <input class="form-check-input" type="checkbox" role="switch" <?php echo e(isset($paymentSettings['midtrans_sandbox_mode']) && $paymentSettings['midtrans_sandbox_mode'] == '1' ? 'checked' : ''); ?> id="switch_midtrans_sandbox_mode">
                                    <label class="form-check-label" for="switch_midtrans_sandbox_mode"></label>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            
            <div class="card">
                <div class="card-body">
                    <a id="search-anchor-bank-details" name="bank-details"></a>
                    
                    <div class="divider pt-3 mt-3">
                        <h6 class="divider-text"><?php echo e(__('Bank Details Setting')); ?></h6>
                    </div>
                    <div class="form-group row">
                        
                        <div class="col-sm-12 col-md-6 mt-2">
                            <label class="form-check-label"><?php echo e(__('Enable Bank Details')); ?></label>
                            <div>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="bank_transfer_status" id="bank_details_enabled" value="<?php echo e(isset($paymentSettings['bank_transfer_status']) && $paymentSettings['bank_transfer_status'] != '' ? $paymentSettings['bank_transfer_status'] : 0); ?>">
                                    <input class="form-check-input" type="checkbox" role="switch" <?php echo e(isset($paymentSettings['bank_transfer_status']) && $paymentSettings['bank_transfer_status'] == '1' ? 'checked' : ''); ?> id="switch_bank_details_enabled">
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-12 mt-3 bank-details-fields">
                            <label class="form-label"><?php echo e(__('Bank Details Fields')); ?></label>
                            <div class="bank-details-repeater">
                                <div data-repeater-list="bank_details_fields">

                                    <div data-repeater-item>

                                        <div class="row mb-2 bg-light p-2">
                                            
                                            <div class="col-12 d-flex justify-content-end">
                                                <button type="button" class="btn btn-danger" data-repeater-delete>
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </div>

                                            
                                            <div class="col-md-4 form-group">
                                                <label class="form-label"><?php echo e(__('Title')); ?></label>
                                                <input type="text" class="form-control" name="title" placeholder="<?php echo e(__('Title')); ?>">
                                            </div>

                                            
                                            <div class="col-md-4 form-group">
                                                <label class="form-label"><?php echo e(__('Value')); ?></label>
                                                <input type="text" class="form-control" name="value" placeholder="<?php echo e(__('Value')); ?>">
                                            </div>

                                            <?php if(isset($languages) && $languages->count() > 0): ?>
                                                
                                                <div class="translation-div mt-2 row">
                                                    <div class="col-12">
                                                        <div class="divider">
                                                            <div class="divider-text">
                                                                <h5><?php echo e(__('Translations for Bank Details Title')); ?></h5>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-md-6 col-xl-4">
                                                            <div class="form-group">
                                                                <label for="translation-<?php echo e($language->id); ?>"><?php echo e($language->name); ?></label>
                                                                <input type="hidden" name="translation_language_id_<?php echo e($language->id); ?>" value="<?php echo e($language->id); ?>">
                                                                <input type="text" name="translation_value_<?php echo e($language->id); ?>" id="translation-<?php echo e($key); ?>-title-<?php echo e($language->id); ?>" class="form-control" placeholder="<?php echo e(__('Enter Title')); ?>">
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </div>

                                
                                <button type="button" class="btn btn-success mt-2" data-repeater-create>
                                    <?php echo e(__('Add Field')); ?>

                                </button>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="col-12 d-flex justify-content-end">
                <button type="submit" name="btnAdd" value="btnAdd" class="btn btn-primary me-1 mb-1"><?php echo e(__('Save')); ?></button>
            </div>
        <?php echo Form::close(); ?>


    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script type="text/javascript">
        $(document).ready(function () {
            // Initialize bank details visibility based on saved state
            if($("#bank_details_enabled").val() == "1") {
                $(".bank-details-fields").show();

                // After DOM is fully rendered, check if we need to add a default item
                setTimeout(() => {
                    const repeaterItems = $('[data-repeater-list="bank_details_fields"] [data-repeater-item]').length;
                    if (repeaterItems === 0) {
                        // Add one default item if none exist
                        $('[data-repeater-create]').trigger('click');
                    }
                }, 100);
            } else {
                $(".bank-details-fields").hide();
            }


            setTimeout(() => {
                bankDetailsRepeater.setList([
                    <?php $__currentLoopData = $bankDetailsFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $bankDetail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        {
                            title: "<?php echo e($bankDetail['title']); ?>",
                            value: "<?php echo e($bankDetail['value']); ?>",
                            <?php if(isset($bankDetail['translations']) && !empty($bankDetail['translations'])): ?>
                                <?php $__currentLoopData = $bankDetail['translations']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $translation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    translation_language_id_<?php echo e($translation['language_id']); ?>: "<?php echo e($translation['language_id']); ?>",
                                    translation_value_<?php echo e($translation['language_id']); ?>: "<?php echo e($translation['title']); ?>",
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        },
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ]);
            }, 100);
        });

        // Paypal
        $("#switch_sandbox_mode").on('change', function() {
            $("#switch_sandbox_mode").is(':checked') ? $("#sandbox_mode").val(1) : $("#sandbox_mode") .val(0);
        });
        $("#switch_paypal_gateway").on('change', function() {
            $("#switch_paypal_gateway").is(':checked') ? $("#paypal_gateway").val(1) : $("#paypal_gateway") .val(0);
        });

        // Razorpay
        $("#switch_razorpay_gateway").on('change', function() {
            $("#switch_razorpay_gateway").is(':checked') ? $("#razorpay_gateway").val(1) : $("#razorpay_gateway") .val(0);
        });

        // Stripe
        $("#switch_stripe_gateway").on('change', function() {
            $("#switch_stripe_gateway").is(':checked') ? $("#stripe_gateway").val(1) : $("#stripe_gateway") .val(0);
        });

        // Paystack
        $("#switch_paystack_gateway").on('change', function() {
            $("#switch_paystack_gateway").is(':checked') ? $("#paystack_gateway").val(1) : $("#paystack_gateway") .val(0);
        });

        // Flutterwave
        $("#switch_flutterwave_status").on('change', function() {
            $("#switch_flutterwave_status").is(':checked') ? $("#flutterwave_status").val(1) : $("#flutterwave_status") .val(0);
        });

        // Cashfree
        $("#switch_cashfree_gateway").on('change', function() {
            $("#switch_cashfree_gateway").is(':checked') ? $("#cashfree_gateway").val(1) : $("#cashfree_gateway") .val(0);
        });
        $("#switch_cashfree_sandbox_mode").on('change', function() {
            $("#switch_cashfree_sandbox_mode").is(':checked') ? $("#cashfree_sandbox_mode").val(1) : $("#cashfree_sandbox_mode") .val(0);
        });

        // Phonepe
        $("#switch_phonepe_gateway").on('change', function() {
            $("#switch_phonepe_gateway").is(':checked') ? $("#phonepe_gateway").val(1) : $("#phonepe_gateway") .val(0);
        });
        $("#switch_phonepe_sandbox_mode").on('change', function() {
            $("#switch_phonepe_sandbox_mode").is(':checked') ? $("#phonepe_sandbox_mode").val(1) : $("#phonepe_sandbox_mode") .val(0);
        });

        // Midtrans
        $("#switch_midtrans_gateway").on('change', function () {
            $("#switch_midtrans_gateway").is(':checked') ? $("#midtrans_gateway").val(1) : $("#midtrans_gateway").val(0);
        });
        $("#switch_midtrans_sandbox_mode").on('change', function () {
            $("#switch_midtrans_sandbox_mode").is(':checked') ? $("#midtrans_sandbox_mode").val(1) : $("#midtrans_sandbox_mode").val(0);
        });

        $("#switch_bank_details_enabled").on('change', function() {
            // Update hidden input value based on switch state
            if($(this).is(':checked')) {
                $("#bank_details_enabled").val(1);
                $(".bank-details-fields").show();

                // Check if there are no items in the repeater
                const repeaterItems = $('[data-repeater-list="bank_details_fields"] [data-repeater-item]').length;
                if (repeaterItems === 0) {
                    // Add one default item if none exist
                    $('[data-repeater-create]').trigger('click');
                }
            } else {
                $("#bank_details_enabled").val(0);
                $(".bank-details-fields").hide();
            }
        });

        function formSuccessFunction(){
            window.location.reload();
        }
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Projects\ebroker-admin\resources\views/settings/payment-gateway-settings.blade.php ENDPATH**/ ?>