<div id="sidebar" class="active">
    <div class="sidebar-wrapper active">
        <div class="sidebar-header position-relative">
            <div class="d-flex justify-content-center">
                <div class="logo">
                    <a href="<?php echo e(url('home')); ?>">
                        <img src="<?php echo e(url('assets/images/logo/' . (system_setting('company_logo') ?? null))); ?>"
                            alt="Logo" srcset="">
                    </a>
                </div>
            </div>
            <!-- Close button -->
            <button class="sidebar-close-btn" type="button" aria-label="Close sidebar">
                <i class="bi bi-x-lg"></i>
            </button>
        </div>
        <div class="sidebar-menu">
            <ul class="menu" id="sidebarMenu">
                
                <?php if(has_permissions('read', 'dashboard')): ?>
                    <li class="sidebar-item">
                        <a href="<?php echo e(url('home')); ?>" class='sidebar-link'>
                            <i class="bi bi-grid-fill"></i>
                            <span class="menu-item"><?php echo e(__('Dashboard')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if(
                        has_permissions('read', 'property') ||
                        has_permissions('read', 'project') ||
                        has_permissions('read', 'categories') ||
                        has_permissions('read', 'facility') ||
                        has_permissions('read', 'near_by_places') ||
                        has_permissions('read', 'city_images')
                    ): ?>
                    <li class="sidebar-item has-sub">
                        <a href="#" class='sidebar-link'>
                            <i class="bi bi-building"></i>
                            <span class="menu-item"><?php echo e(__('Properties & Locations')); ?></span>
                        </a>
                        <ul class="submenu" style="padding-left: 0rem">
                            
                            <?php if(has_permissions('read', 'property')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('property')); ?>">
                                        <?php echo e(__('Properties')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'project')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('project')); ?>">
                                        <?php echo e(__('Projects')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'categories')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('categories')); ?>"><?php echo e(__('Categories')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'facility')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('parameters')); ?>"><?php echo e(__('Facilities')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'near_by_places')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('outdoor_facilities')); ?>"><?php echo e(__('Nearby Places')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'city_images')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('city-images.index')); ?>"><?php echo e(__('City Images')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if(
                        has_permissions('read', 'advertisement') ||
                        has_permissions('read', 'slider') ||
                        has_permissions('read', 'article') ||
                        has_permissions('read', 'homepage-sections') ||
                        has_permissions('read', 'faqs')
                    ): ?>
                    <li class="sidebar-item has-sub">
                        <a href="#" class='sidebar-link'>
                            <i class="bi bi-badge-ad"></i>
                            <span class="menu-item"><?php echo e(__('Marketing & content')); ?></span>
                        </a>
                        <ul class="submenu" style="padding-left: 0rem">
                            
                            <?php if(has_permissions('read', 'advertisement')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('ad-banners.index')); ?>"><?php echo e(__('Advertisement banners')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'advertisement')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('featured_properties')); ?>"><?php echo e(__('Advertisements')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'homepage-sections')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('homepage-sections.index')); ?>"><?php echo e(__('Homepage Sections')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'slider')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('slider')); ?>">
                                        <?php echo e(__('Slider')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'article')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('article')); ?>"><?php echo e(__('Articles')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'faqs')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('faqs.index')); ?>"><?php echo e(__('FAQs')); ?></a>
                                </li>
                            <?php endif; ?>

                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if(
                        has_permissions('read', 'verify_customer_form') ||
                        has_permissions('read', 'approve_agent_verification')
                    ): ?>
                    <li class="sidebar-item has-sub">
                        <a href="#" class='sidebar-link'>
                            <i class="bi bi-shield-check"></i>
                            <span class="menu-item"><?php echo e(__('Agents')); ?></span>
                        </a>
                        <ul class="submenu" style="padding-left: 0rem">
                            
                            <?php if(has_permissions('read', 'approve_agent_verification')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('agent-verification.index')); ?>">
                                        <?php echo e(__('Agent Verification')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'verify_customer_form')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('verify-customer.form')); ?>"><?php echo e(__('Custom fields')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if(
                        has_permissions('read', 'appointment_management') ||
                        has_permissions('read', 'appointment_reports') ||
                        has_permissions('read', 'admin_appointment_preferences')
                    ): ?>
                    <li class="sidebar-item has-sub">
                        <a href="#" class='sidebar-link'>
                            <i class="bi bi-calendar"></i>
                            <span class="menu-item"><?php echo e(__('Appointments')); ?></span>
                        </a>
                        <ul class="submenu" style="padding-left: 0rem">
                            
                            <?php if(has_permissions('read', 'appointment_management')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('appointment-management.index')); ?>">
                                        <?php echo e(__('Appointments List')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'appointment_reports')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('admin.appointment.reports.index')); ?>"><?php echo e(__('Appointment reports')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'admin_appointment_preferences')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('admin.appointment.index')); ?>"><?php echo e(__('Appointment settings')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if(
                        has_permissions('read', 'package') ||
                        has_permissions('read', 'package-feature') ||
                        has_permissions('create', 'package-feature') ||
                        has_permissions('create', 'package') ||
                        has_permissions('read', 'user_package') ||
                        has_permissions('read', 'payment') ||
                        has_permissions('read', 'assign_package') ||
                        has_permissions('read', 'calculator')
                    ): ?>
                    <li class="sidebar-item has-sub">
                        <a href="#" class='sidebar-link'>
                            <i class="bi bi-file-earmark-text"></i>
                            <span class="menu-item"><?php echo e(__('Plans & billing')); ?></span>
                        </a>
                        <ul class="submenu" style="padding-left: 0rem">
                            
                            <?php if(has_permissions('read', 'package-feature') || has_permissions('create', 'package-feature')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('package-features.index')); ?>"><?php echo e(__('Features')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'package') || has_permissions('create', 'package')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('package.index')); ?>"><?php echo e(__('Packages')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'user_package')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('user-packages.index')); ?>"><?php echo e(__('Users packages')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'assign_package')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('assign-package.index')); ?>"><?php echo e(__('Assign package')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'payment')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('payment.index')); ?>"><?php echo e(__('Payment')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'calculator')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('calculator')); ?>"><?php echo e(__('Calculator')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'chat') || has_permissions('read', 'notification')): ?>
                    <li class="sidebar-item has-sub">
                        <a href="#" class='sidebar-link'>
                            <i class="bi bi-chat-dots"></i>
                            <span class="menu-item"><?php echo e(__('Communication')); ?></span>
                        </a>
                        <ul class="submenu" style="padding-left: 0rem">
                            
                            <?php if(has_permissions('read', 'chat')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('get-chat-list')); ?>">
                                        <?php echo e(__('Chat')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'notification')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('notification')); ?>"><?php echo e(__('Notification')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if(
                        has_permissions('read', 'customer') ||
                        has_permissions('read', 'users_inquiries') ||
                        has_permissions('read', 'user_reports') ||
                        has_permissions('read', 'report_reason')
                    ): ?>
                    <li class="sidebar-item has-sub">
                        <a href="#" class='sidebar-link'>
                            <i class="bi bi-person"></i>
                            <span class="menu-item"><?php echo e(__('User Management')); ?></span>
                        </a>
                        <ul class="submenu" style="padding-left: 0rem">
                            
                            <?php if(has_permissions('read', 'customer')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('customer')); ?>"><?php echo e(__('Customers')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'users_inquiries')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('users_inquiries')); ?>"><?php echo e(__('User Inquiries')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'user_reports')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('users_reports')); ?>"><?php echo e(__('User reports')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'report_reason')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('report-reasons')); ?>"><?php echo e(__('Report reasons')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if(
                        has_permissions('read', 'about_us') ||
                        has_permissions('read', 'privacy_policy') ||
                        has_permissions('read', 'terms_conditions')
                    ): ?>
                    <li class="sidebar-item has-sub">
                        <a href="#" class='sidebar-link'>
                            <i class="bi bi-file-earmark"></i>
                            <span class="menu-item"><?php echo e(__('Pages')); ?></span>
                        </a>
                        <ul class="submenu" style="padding-left: 0rem">
                            
                            <?php if(has_permissions('read', 'about_us')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('about-us')); ?>"><?php echo e(__('About us')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'privacy_policy')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('privacy-policy')); ?>"><?php echo e(__('Privacy policy')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'terms_conditions')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('terms-conditions')); ?>"><?php echo e(__('Terms & conditions')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if(
                        has_permissions('read', 'users_accounts') ||
                        has_permissions('read', 'language') ||
                        has_permissions('read', 'system_settings') ||
                        has_permissions('read', 'payment_gateway_settings') ||
                        has_permissions('read', 'app_settings') ||
                        has_permissions('read', 'web_settings') ||
                        has_permissions('read', 'seo_settings') ||
                        has_permissions('read', 'firebase_settings') ||
                        has_permissions('read', 'notification_settings') ||
                        has_permissions('read', 'email_configurations') ||
                        has_permissions('read', 'email_templates') ||
                        has_permissions('read', 'gemini_settings')
                    ): ?>
                    <li class="sidebar-item has-sub">
                        <a href="#" class='sidebar-link'>
                            <i class="bi bi-gear"></i>
                            <span class="menu-item"><?php echo e(__('Settings')); ?></span>
                        </a>
                        <ul class="submenu" style="padding-left: 0rem">
                            
                            <?php if(has_permissions('read', 'users_accounts')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('users')); ?>"><?php echo e(__('User accounts')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'language') || has_permissions('create', 'language') || has_permissions('update', 'language') || has_permissions('delete', 'language')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('language')); ?>"><?php echo e(__('Languages')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'system_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('system-settings')); ?>"><?php echo e(__('System Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'payment_gateway_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('payment-gateway-settings.index')); ?>"><?php echo e(__('Payment Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'app_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('app-settings')); ?>"><?php echo e(__('App Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'web_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('web-settings')); ?>"><?php echo e(__('Web Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'seo_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('seo_settings')); ?>"><?php echo e(__('SEO Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'firebase_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('firebase_settings')); ?>"><?php echo e(__('Firebase Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'notification_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('notification-setting-index')); ?>"><?php echo e(__('Notification Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'email_templates')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('email-templates.index')); ?>"><?php echo e(__('Email Templates')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'email_configurations')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('email-configurations-index')); ?>"><?php echo e(__('Email Configurations')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'watermark_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('watermark-settings-index')); ?>"><?php echo e(__('Watermark Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'gemini_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('gemini-settings.index')); ?>"><?php echo e(__('Gemini AI Settings')); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if(has_permissions('read', 'demo_data')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(route('demo-data.index')); ?>"><?php echo e(__('Demo Data Setup')); ?></a>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(has_permissions('read', 'system_settings')): ?>
                                <li class="submenu-item">
                                    <a href="<?php echo e(url('log-viewer')); ?>"><?php echo e(__('Log Viewer')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if(has_permissions('read', 'system_update')): ?>
                    <li class="sidebar-item has-sub">
                        <a href="#" class='sidebar-link'>
                            <i class="bi bi-tools"></i>
                            <span class="menu-item"><?php echo e(__('System')); ?></span>
                        </a>
                        <ul class="submenu" style="padding-left: 0rem">
                            
                            <li class="submenu-item">
                                <a href="<?php echo e(url('system-version')); ?>"><?php echo e(__('System Update')); ?></a>
                            </li>
                        </ul>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div><?php /**PATH C:\Projects\ebroker-admin\resources\views/layouts/sidebar.blade.php ENDPATH**/ ?>